/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.sql.SQLException;

import org.apache.commons.csv.CSVParser;
import org.apache.commons.fileupload.FileItem;

import jp.mosp.common.CommonConst;
import jp.mosp.common.CommonUtility;
import jp.mosp.common.DataSourceUtility;
import jp.mosp.common.ExportInfoUtility;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.CmAuthorityDao;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dao.CmComponentDao;
import jp.mosp.common.dao.MosPConfDao;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.dto.MosPUserDto;
import jp.mosp.common.vo.ExclusiveVo;
import jp.mosp.common.vo.MosPVo;

import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;

import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.MKintaiKeisanDto;

import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dao.MExportColumnDao;
import jp.mosp.system.dao.MKaisyaDao;
import jp.mosp.system.dao.MSyozokuDao;
import jp.mosp.system.dao.MWorkTypeDao;
import jp.mosp.system.dao.MYakusyokuDao;

import jp.mosp.system.dto.MCodeDto;
import jp.mosp.system.dto.MExportColumnDto;
import jp.mosp.system.dto.MKaisyaDto;
import jp.mosp.system.dto.MSyozokuDto;
import jp.mosp.system.dto.MWorkTypeDto;
import jp.mosp.system.dto.MYakusyokuDto;

public abstract class MosPAction extends BaseAction {

	// r֘AtB[h
	private boolean needExclusive;
	private List    listExclusive;

	// tB[h
	protected MosPUserDto mospUser;
	protected MKihonDto mKihon;

	protected BufferedReader br;

	protected CommonUtility util;

	/**
	 * RXgN^
	 */
	public MosPAction() {
		super();
		setCheckAuth(false);
		setNeedExclusive(false);
		util = new CommonUtility();
	}

	/**
	 * ANV㏈
	 * @throws SQLException
	 */
	@Override
	protected void afterAction() throws SQLException {
		super.afterAction();
		if (!needExclusive) {
			if (user != null) {
				deleteExclusive(user.getUserId());
			}
		}
	}

	/**
	 * CmAspUserDto̐
	 */
	protected void createAspUser() {
		aspUser = new CmAspUserDto();
		aspUser.setAspUserId(cfg.getProperty(MospConst.PPT_ASP_ASPUSER));
		aspUser.setAspName(cfg.getProperty(MospConst.PPT_ASP_ASPNAME));
		aspUser.setDbDriver(cfg.getProperty(MospConst.PPT_ASP_DBDRIVER));
		aspUser.setDbUrl(cfg.getProperty(MospConst.PPT_ASP_DBURL));
		aspUser.setDbUser(cfg.getProperty(MospConst.PPT_ASP_DBUSER));
		aspUser.setDbPass(cfg.getProperty(MospConst.PPT_ASP_DBPASS));
	}

	/**
	 * St@Cp۔f
	 */
	protected void setUseLogo() {
		boolean useLogoFlag = false;
		String useLogo = cfg.getProperty(CommonConst.PPT_USE_LOGO);
		if (useLogo != null 
				&& useLogo.length() != 0 
				&& Boolean.parseBoolean(useLogo) 
				&& new File(
						cfg.getProperty(MospConst.PPT_APP_DOCBASE) + CommonConst.FILE_LOGO
				) != null
		) {
			useLogoFlag = true;
		}
		cfg.setProperty(CommonConst.PPT_USE_LOGO, String.valueOf(useLogoFlag));
	}

	/**
	 * VOCX^X擾
	 * @return	VO
	 * <p>
	 * MosP̋@\pčꍇÃ\bhI[o[Ch邱ƂŁA
	 * MosPVopꂼVOCX^X̂擾B
	 * </p>
	 */
	protected MosPVo getInitVo() {
		return null;
	}

	/**
	 * 폜tOXg擾
	 * @return 폜tOXg
	 */
	protected String[][] getDeleteArray() {
		String[][] array = new String[2][2];
		array[0][0] = String.valueOf(MospConst.DELETE_FLAG_OFF);
		array[0][1] = MospConst.DELETE_FLAG_OFF_NAME;
		array[1][0] = String.valueOf(MospConst.DELETE_FLAG_ON);
		array[1][1] = MospConst.DELETE_FLAG_ON_NAME;
		return array;
	}

	/**
	 * KptOXg擾
	 * @return 폜tOXg
	 */
	protected String[][] getApplicableFlagArray() {
		String[][] array = new String[2][2];
		array[0][0] = String.valueOf(CommonConst.APPLICABLE_FLAG_OFF);
		array[0][1] = CommonConst.NAM_APPLICABLE_FLAG_OFF;
		array[1][0] = String.valueOf(CommonConst.APPLICABLE_FLAG_ON);
		array[1][1] = CommonConst.NAM_APPLICABLE_FLAG_ON;
		return array;
	}

	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception
	 */
	protected String[][] getConfArray(String confId) throws Exception {
		// DAO̐錾
		MosPConfDao dao = new MosPConfDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<MosPConfDto> list = dao.findForCondition(confId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			MosPConfDto dto = list.get(i);
			array[i][0] = dto.getConfCode();
			array[i][1] = dto.getConfValue();
		}
		return array;
	}

	/**
	 * ݒl擾(MOSP_CONF)
	 * @param confId   ݒ敪
	 * @param confCode ݒR[h
	 * @return ݒl
	 * @throws Exception
	 */
	protected String getConfValue(String confId, String confCode) throws Exception {
		// DAO̐錾
		MosPConfDao dao = new MosPConfDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		MosPConfDto dto = dao.findForKey(confId, confCode);
		if (dto == null) {
			return "";
		}
		return dto.getConfValue();
	}

	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected List<MosPConfDto> getConfList(
			String confId
	) throws SQLException, IllegalAccessException, NoSuchFieldException  {
		// DAO̐錾
		MosPConfDao dao = new MosPConfDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		return dao.findForCondition(confId);
	}

	/**
	 * [U[擾
	 * @param userId Ώۃ[U[ID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected void getInfo(
			String userId
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		mospUser 	= getUserInfo(userId);
		mKihon 		= getBasisInfo(mospUser.getKCode());
	}

	/**
	 * l{擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return l{(UmBasisDto)
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected MKihonDto getBasisInfo(
			String kCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		return dao.findForKey(kCode);
	}

	/**
	 * Ј擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return Ј
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getKName(
			String kCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		MKihonDto dto = getBasisInfo(kCode);
		if (dto == null) {
			return kCode;
		}
		return dto.getSimei();
	}

	/**
	 * ЈR[h擾(M_KIHON)()
	 * @param sectionCode R[h
	 * @return ЈR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[] getBasisArray(
			String sectionCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKihonDto> listKihon = dao.findForSection(
				sectionCode,
				util.convDateToInteger(util.getSystemDate())
		);
		// z̍쐬
		String[] aryKihon = new String[listKihon.size()];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i] = listKihon.get(i).getKCode();
		}
		return aryKihon;
	}

	/**
	 * ЈR[h擾(M_KIHON)(wN)
	 * @param sectionCode R[h
	 * @param targetMonth IN
	 * @return ЈR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[] getBasisArray(
			String sectionCode,
			Date targetMonth
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKihonDto> listKihon = dao.findForSection(
				sectionCode,
				util.convDateToInteger(targetMonth)
		);
		// z̍쐬
		String[] aryKihon = new String[listKihon.size()];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i] = listKihon.get(i).getKCode();
		}
		return aryKihon;
	}

	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getBasisArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKihonDto> listKihon = dao.findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getSimei();
		}
		return aryKihon;
	}

	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getBasisArrayForApproval() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKihonDto> listKihon = dao.findForAuth(
				CommonConst.AUTHORITY_MANAGER,
				CommonConst.AUTHORITY_SENIORS,
				util.convDateToInteger(util.getSystemDate())
		);
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getSimei();
		}
		return aryKihon;
	}

	/**
	 * ЈR[hAR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[][] getBasisArrayAllWithSectionCode() throws Exception {
		// DAȌ
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKihonDto> listKihon = dao.findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = getBelongSectionCode(listKihon.get(i).getKCode());
		}
		return aryKihon;
	}

	/**
	 * IЈЈR[hꗗ擾(M_KIHON)
	 * @param kcode		ΏێЈR[h
	 * @return	ЈR[hXg
	 * @throws Exception
	 */
	protected String[][] getBasisArrayForBelongSection(String kcode) throws Exception {
		// 
		MKihonDao mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
		List<MKihonDto> listMKihon = mKihonDao.findForCondition(
				getBelongSectionCode(kcode),
				mKihon.getJCode(),
				mKihon.getKCode(),
				mospUser.getDataLevel(),
				util.convDateToInteger(util.getSystemDate())
		);
		String[][] aryBasis = new String[listMKihon.size()][2];
		for (int i = 0; i < aryBasis.length; i++) {
			aryBasis[i][0] = listMKihon.get(i).getKCode();
			aryBasis[i][1] = listMKihon.get(i).getSimei();
		}
		return aryBasis;
	}

	/**
	 * ΑNij擾
	 * @param kCode
	 * @return y.m<br>͂̂܂
	 * 				[] 262.02N
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected double getYearsOfService(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		MKihonDto dto = getBasisInfo(kCode);
		int difference = 0;
		if (dto != null) {
			difference = util.getMonthRemainder(
					util.getSystemDate(),
					util.convIntegerDateToDate(dto.getNyDate())
			);			
		}
		double yearsOfService = difference /12 + difference %12 /100;
		return yearsOfService;
	}

	/**
	 * ݐEЈ擾
	 * @param kCode		ΏێЈR[h
	 * @return			ݐEЈ
	 * @throws Exception
	 */
	protected MKihonDto getAvailableUserInfo(String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		if (chkExistDto(dto)) {
			// ސE敪ސȄꍇB
			if (isRetiredEmployee(kCode)) {
				return null;
			}
			// ސE敪xȄꍇB
			if (dto.getKnKubun().equals(String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE))) {
				return null;
			}
		}
		return dto;
	}

	/**
	 * ސEf
	 * @param kCode		ΏێЈR[h
	 * @return
	 * <p>
	 * ސȄꍇBtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception
	 */
	protected boolean isRetiredEmployee (String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		if (chkExistDto(dto)) {
			// ސE敪ސEAސEt{ȌꍇB
			if (dto.getKnKubun().equals(String.valueOf(CommonConst.RETIREMENT_FLAG_ON))
					&& (dto.getTsDate() > 0
							&& dto.getTsDate() < util.convDateToInteger(util.getSystemDate())
					)
			) {
				return true;
			}
		} else {
			return true;
		}
		return false;
	}

	/**
	 * R[hXg擾(CM_CODE)
	 * @param tId R[h敪
	 * @return R[hXg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	@Override
	protected String[][] getCodeArray(String tId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO̐錾
		CmCodeDao dao = new CmCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<CmCodeDto> list = dao.findForCondition(tId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmCodeDto dto = list.get(i);
			array[i][0] = dto.getTCode();
			array[i][1] = dto.getTName();
		}
		return array;
	}

	/**
	 * R[h敪擾(CM_CODE)
	 * @return R[h敪Xg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getCodeArray() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		CmCodeDao dao = new CmCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h敪̎擾(distinctf[^)
		List<CmCodeDto> list = dao.findAllTId();     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			String tId = list.get(i).getTId();
			aryCode[i][0] = tId;
			aryCode[i][1] = getCodeTypeName(tId);
		}
		return aryCode;
	}

	/**
	 * R[h敪̎擾(CM_CODE)
	 * @param	tId R[h敪
	 * @return	tId R[h敪
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getCodeTypeName(String tId) {
		if (tId.equals(CommonConst.TID_AUTHORITY)) {
			return CommonConst.TNM_AUTHORITY;
		} else {
			return tId;
		}
	}

	/**
	 * R[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected String[][] getArrangeAuthArray() throws SQLException, IllegalAccessException, NoSuchFieldException{
		// DAO̐錾
		CmAuthorityDao dao = new CmAuthorityDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<CmAuthorityDto> list = dao.findForAvailable();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmAuthorityDto dto = list.get(i);
			array[i][0] = dto.getAuthCode();
			array[i][1] = dto.getAuthName();
		}
		return array;
	}

	/**
	 * SR[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected String[][] getArrangeAuthArrayAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO̐錾
		CmAuthorityDao dao = new CmAuthorityDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<CmAuthorityDto> list = dao.findAll();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmAuthorityDto dto = list.get(i);
			array[i][0] = dto.getAuthCode();
			array[i][1] = dto.getAuthName();
		}
		return array;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[h敪Xg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getMosPCodeArray() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h敪̎擾(distinctf[^)
		List<MCodeDto> list = dao.findAllTId();     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			String tId = list.get(i).getTId();
			aryCode[i][0] = tId;
			aryCode[i][1] = tId;
		}
		return aryCode;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @param tid R[hID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getMosPCodeArray(String tid) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h̎擾
		List<MCodeDto> list = dao.findForCondition(tid);     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
		}
		return aryCode;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getMosPCodeArray(String tid, String tcode) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h̎擾
		List<MCodeDto> list = dao.findForCondition(tid, tcode);     
		String[][] aryCode = new String[list.size()][3];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
			aryCode[i][2] = list.get(i).getTChange();
		}
		return aryCode;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[] getMosPCode(String tid, String tcode) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h̎擾
		MCodeDto dto = dao.findForKey(tid, tcode);     
		String[] aryCode = new String[3];
		// Sting̔zɊi[
		if (dto != null) {
			for (int i = 0; i < 3; i++) {
				aryCode[0] = dto.getTCode();
				aryCode[1] = dto.getTName();
				aryCode[2] = dto.getTChange();
			}
		}
		return aryCode;
	}

	/**
	 * R敪擾(M_CODE)
	 * @param tid R[hID
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getReasonCodeArray(String tid) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h̎擾
		List<MCodeDto> list = dao.findForReason(tid);     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
		}
		return aryCode;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[] getMosPCode(String tid) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h̎擾
		MCodeDto dto = dao.findForDto(tid);     
		String[] aryCode = new String[3];
		// Sting̔zɊi[
		for (int i = 0; i < 3; i++) {
			aryCode[0] = dto.getTCode();
			aryCode[1] = dto.getTName();
			aryCode[2] = dto.getTChange();
		}
		return aryCode;
	}

	/**
	 * [U[擾(MOSP_USER)
	 * @param userId 擾Ώۃ[U[ID
	 * @return [U[(UmUserDto)
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected MosPUserDto getUserInfo(
			String userId
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		return dao.findForKey(userId);
	}

	/**
	 * [U[擾(MOSP_USER)
	 * @param kcode		擾ΏێЈR[h
	 * @return [U[(UmUserDto)
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected MosPUserDto getUserInfoForKCode(String kcode) throws SQLException, NoSuchFieldException, IllegalAccessException {
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		return dao.findForKCode(kcode);
	}

	/**
	 * MANAGERmF
	 * @return TRAINERL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasManagerAuth() throws Exception {
		// MANAGERmF
		boolean hasAuth = false;
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		String userAuth = mospUser.getAuthority();
		CmAuthorityDao dao = new CmAuthorityDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		CmAuthorityDto dto = dao.findForKey(userAuth);
		// ftHgR[h̐ݒ
		if (dto == null 
				&& (userAuth.equals(CommonConst.AUTHORITY_MANAGER) 
						|| userAuth.equals(CommonConst.AUTHORITY_SENIORS)
				)
		) {
			dto = new CmAuthorityDto();
			dto.setManager(CommonConst.CONF_ID_MANAGER);	
		}
		if (dto != null && !dto.getManager().equals("")) {
			hasAuth = true;
		}		
		return hasAuth;
	}

	/**
	 * MANAGERmF
	 * @throws Exception
	 */
	protected void confirmManagerAuth() throws Exception {
		if (!hasManagerAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * PAYROLLmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasPayrollAuth() throws Exception {
		// PAYROLLmF
		boolean hasAuth = false;
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		String userAuth = mospUser.getAuthority();
		CmAuthorityDao dao = new CmAuthorityDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		CmAuthorityDto dto = dao.findForKey(userAuth);
		// ftHgR[h̐ݒ
		if (dto == null
				&& (userAuth.equals(CommonConst.AUTHORITY_PAYROLL) 
						|| userAuth.equals(CommonConst.AUTHORITY_SENIORS)
						|| userAuth.equals(CommonConst.AUTHORITY_CALCULATE)
				)
		) {
			dto = new CmAuthorityDto();
			dto.setPayroll(CommonConst.CONF_ID_PAYROLL);	
		}
		if (dto != null && !dto.getPayroll().equals("")) {
			hasAuth = true;
		}		
		return hasAuth;
	}

	/**
	 * PAYROLLmF
	 * @throws Exception
	 */
	protected void confirmPayrollAuth() throws Exception {
		if (!hasPayrollAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * HUMANmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasHumanAuth() throws Exception {
		// HUMANmF
		boolean hasAuth = false;
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		String userAuth = mospUser.getAuthority();
		CmAuthorityDao dao = new CmAuthorityDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		CmAuthorityDto dto = dao.findForKey(userAuth);
		// ftHgR[h̐ݒ
		if (dto == null 
				&& (userAuth.equals(CommonConst.AUTHORITY_HUMAN) 
						|| userAuth.equals(CommonConst.AUTHORITY_SENIORS)
				)
		) {
			dto = new CmAuthorityDto();
			dto.setHuman(CommonConst.CONF_ID_HUMAN);
		}
		if (dto != null && !dto.getHuman().equals("")) {
			hasAuth = true;
		}
		return hasAuth;
	}

	/**
	 * HUMANmF
	 * @throws Exception
	 */
	protected void confirmHumanAuth() throws Exception {
		if (!hasHumanAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * CALCULATEmF
	 * @return CALCULATEL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasCalculateAuth() throws Exception {
		// CALCULATEmF
		boolean hasAuth = false;
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		String userAuth = mospUser.getAuthority();
		CmAuthorityDao cmAuthorityDao = new CmAuthorityDao();
		cmAuthorityDao.initDao(cfg, cmd, aspUser, user, conn);
		CmComponentDao cmComponentDao = new CmComponentDao();
		cmComponentDao.initDao(cfg, cmd, aspUser, user, conn);
		CmComponentDto cmComponentDto = null;
		CmAuthorityDto cmAuthorityDto = cmAuthorityDao.findForKey(userAuth);
		if (cmAuthorityDto != null) {
			cmComponentDto = cmComponentDao.findForDto(cmAuthorityDto.getPayroll(), CommonConst.CONF_ID_PAYROLL);
		}
		if (userAuth.equals(CommonConst.AUTHORITY_CALCULATE)) {
			// ftHgR[h̐ݒ
			if (cmAuthorityDto == null) {
				cmAuthorityDto = new CmAuthorityDto();
				cmAuthorityDto.setPayroll(CommonConst.CONF_ID_CALCULATE);	
				cmComponentDto = cmComponentDao.findForDto(cmAuthorityDto.getPayroll(), CommonConst.CONF_ID_PAYROLL);
			}
			// ftHgR[h̐ݒ
			if (cmComponentDto == null) {
				cmComponentDto = new CmComponentDto();
				cmComponentDto.setComponent(MosPMenuConst.getCalcCmdArray()[1]);	
			}			
		}
		if (cmComponentDto != null) {
			String [] aryCmd = util.divideByComma(cmComponentDto.getComponent());
			for (int i = 0; i < aryCmd.length ; i++) {
				if (aryCmd[i].equals(MosPMenuConst.getCalcCmdArray()[1])
						|| aryCmd[i].equals(MosPMenuConst.getCalcCmdArray()[5])
						|| aryCmd[i].equals(MosPMenuConst.getPayrollCmdArray()[7][0])
						|| aryCmd[i].equals(MosPMenuConst.getPayrollCmdArray()[8][0])		
				) {
					hasAuth = true;
					break;
				}			
			}
		}
		return hasAuth;
	}

	/**
	 * CALCULATEmF
	 * @throws Exception
	 */
	protected void confirmCalculateAuth() throws Exception {
		if (!hasCalculateAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * SYSTEMmF
	 * @return SYSTEML(trueFLAfalseF)
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	protected boolean hasSystemAuth() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// ADMINmF
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		return mospUser.getAuthority().equals(CommonConst.AUTH_SYSTEM);
	}

	/**
	 * SYSTEMmF
	 * @throws MospException
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	protected void confirmSystemAuth() throws MospException, SQLException, NoSuchFieldException, IllegalAccessException {
		if (!hasSystemAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * Ə擾(M_KAISYA)
	 * @param jCode 擾ΏێƏR[h
	 * @return Ə(MKaisyaDto)
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected MKaisyaDto getOfficeInfo(
			String jCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		return dao.findForKey(jCode);
	}

	/**
	 * ƏR[h擾(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getOfficeArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKaisyaDto> listOffice = dao.findAll();
		// z̍쐬
		String[][] aryOffice = new String[listOffice.size()][2];
		for (int i = 0; i < listOffice.size(); i++) {
			aryOffice[i][0] = listOffice.get(i).getId();
			aryOffice[i][1] = listOffice.get(i).getKaiMei();
		}
		return aryOffice;
	}

	/**
	 * ƏR[h擾(p\̂)(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws Exception
	 */
	protected String[][] getOfficeArray() throws Exception {
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKaisyaDto> listOffice;
		if (hasPayrollAuth()) {
			listOffice = dao.findAll();
		} else {
			listOffice = dao.findForCondition(mKihon.getJCode());
		}
		// z̍쐬
		String[][] aryOffice = new String[listOffice.size()][2];
		for (int i = 0; i < listOffice.size(); i++) {
			aryOffice[i][0] = listOffice.get(i).getId();
			aryOffice[i][1] = listOffice.get(i).getKaiMei();
		}
		return aryOffice;
	}

	/**
	 * ƏR[h擾î݁j(M_KAISYA)
	 * @param kCode 擾ΏێЈR[h
	 * @return ƏR[h
	 * @throws Exception
	 */
	protected String getBelongOfficeCode(String kCode) throws Exception {
		String strJCode = "";
		// l{擾
		MKihonDto mKihonDto = getBasisInfo(kCode);
		if (chkExistDto(mKihonDto)) {
			strJCode = mKihonDto.getJCode();
			// Ə擾
			if (strJCode != null) {
				MKaisyaDao dao = new MKaisyaDao();
				dao.initDao(cfg, cmd, aspUser, user, conn);
				MKaisyaDto dto = dao.findForKey(strJCode);
				if (chkExistDto(dto)) {
					strJCode = dto.getId();
				} else {
					strJCode = "";
				}
			}
		}
		return strJCode;
	}

	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return (MSyozokuDto)
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected MSyozokuDto getSectionInfo(
			String sCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		return dao.findForKey(sCode);
	}

	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return 
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getSectionName(
			String sCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		String sName = "";
		MSyozokuDto dto = getSectionInfo(sCode);
		if (dto != null) {
			sName = dto.getSName();
		}
		return sName;
	}

	/**
	 * R[h擾
	 * @param kCode 擾ΏێЈR[h
	 * @return R[h
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws MospException 
	 * @throws Exception
	 */
	protected String getBelongSectionCode(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException  {
		String strStationCode = "";
		// l{擾
		MKihonDto mKihonDto = getBasisInfo(kCode);
		if (chkExistDto(mKihonDto)) {
			strStationCode = mKihonDto.getSCode();
			// 擾
			if (strStationCode != null) {
				MSyozokuDao dao = new MSyozokuDao();
				dao.initDao(cfg, cmd, aspUser, user, conn);
				MSyozokuDto dto = dao.findForKey(strStationCode);
				if (chkExistDto(dto)) {
					strStationCode = dto.getSCode();
				} else {
					strStationCode = "";
				}
			}
		}
		return strStationCode;
	}

	/**
	 * R[h擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getSectionArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MSyozokuDto> listSection = dao.findAll();
		// z̍쐬
		String[][] arySection = new String[listSection.size()][2];
		for (int i = 0; i < listSection.size(); i++) {
			arySection[i][0] = listSection.get(i).getSCode();
			arySection[i][1] = listSection.get(i).getSName();
		}
		return arySection;
	}

	/**
	 * R[h擾(p\ĉ)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected String[][] getSectionArrayForManager() throws Exception {
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		// DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MSyozokuDto> listSection = dao.findForCondition(mKihon.getSCode());
		if (listSection.size() == 0) {
			// j[ɖ߂
			String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_NO_AVAILABLE_STA, "");
			addErrMessage(errMessage);
			setNextCmd(MosPMenuAction.CMD_SHOW);
			throw new MospException(CommonConst.EX_NO_AVAILABLE_STA, errMessage);
		}
		// z̍쐬
		String[][] aryStation = new String[listSection.size()][2];
		for (int i = 0; i < listSection.size(); i++) {
			aryStation[i][0] = listSection.get(i).getSCode();
			aryStation[i][1] = listSection.get(i).getSName();
		}
		return aryStation;
	}

	/**
	 * R[h擾(p\cɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected String[][] getSectionArrayForHuman() throws Exception {
		if (mospUser == null) {
			getInfo(user.getUserId());
		}
		// DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MSyozokuDto> listSection;
		// 쌠mF		
		if (hasHumanAuth()) {
			listSection = dao.findAll();
		} else {
			listSection = dao.findForCondition(mKihon.getSCode());		
		}
		if (listSection.size() == 0) {
			// j[ɖ߂
			String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_NO_AVAILABLE_STA, "");
			addErrMessage(errMessage);
			setNextCmd(MosPMenuAction.CMD_SHOW);
			throw new MospException(CommonConst.EX_NO_AVAILABLE_STA, errMessage);
		}
		// z̍쐬
		String[][] aryStation = new String[listSection.size()][2];
		for (int i = 0; i < listSection.size(); i++) {
			aryStation[i][0] = listSection.get(i).getSCode();
			aryStation[i][1] = listSection.get(i).getSName();
		}
		return aryStation;
	}

	/**
	 * R[h擾(͈͂ɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected String[][] getSectionScopeArrayForPayroll() throws Exception {
		CmComponentDto cmComponentDto = new CmComponentDto();
		String userAuth = mospUser.getAuthority();
		CmComponentDao cmComponentDao = new CmComponentDao();
		cmComponentDao.initDao(cfg, cmd, aspUser, user, conn);
		CmAuthorityDao cmAuthorityDao = new CmAuthorityDao();
		cmAuthorityDao.initDao(cfg, cmd, aspUser, user, conn);
		CmAuthorityDto cmAuthorityDto;
		cmAuthorityDto = cmAuthorityDao.findForKey(userAuth);
		String [][] ary = null ;
		if (cmAuthorityDto != null) {
			cmComponentDto = cmComponentDao.findForKey(cmAuthorityDto.getPayroll());
		}
		// ftHg̐ݒ
		if (userAuth.equals(CommonConst.AUTHORITY_CALCULATE)) {
			cmComponentDto.setManage(getManageCode()[2]);
		} else if (userAuth.equals(CommonConst.AUTHORITY_PAYROLL)) {
			cmComponentDto.setManage(getManageCode()[0]);
		}
		// v_Eݒ
		if (cmComponentDto.getManage() == getManageCode()[0]) {
			ary = getSectionArrayForManager();			
		} else if (cmComponentDto.getManage() == getManageCode()[1]) {
			ary = getSectionArrayAll();
		} else {
			ary = util.addArrayFirstRowValue(
					getSectionArrayAll(),
					CommonConst.NAM_COMMON_STRING_INITIAL_VALUE,
					CommonConst.NAM_ALL_SECTION);
		}
		return ary;
	}

	/**
	 * Xg擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected Map<String, MSyozokuDto> getSectionMap() throws Exception {
		// DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MSyozokuDto> listSection;
		listSection = dao.findAll();
		// z̍쐬
		HashMap<String, MSyozokuDto> map = new HashMap<String, MSyozokuDto>();
		for (int i = 0; i < listSection.size(); i++) {
			map.put(listSection.get(i).getSCode(), listSection.get(i));
		}
		return map;
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getWorkTypeArrayNotDeleted() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MWorkTypeDto> listWorkType = dao.findAvailable();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		return aryWorkType;
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)iTxtj
	 * @return Ζ`ԃR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getWorkTypeArrayWithWeekHoliday() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MWorkTypeDto> listWorkType = dao.findAvailable();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		aryWorkType = util.addArrayLastRowValue(aryWorkType,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		return aryWorkType;
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getWorkTypeArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MWorkTypeDto> listWorkType = dao.findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		return aryWorkType;
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getWorkTypeArrayAllWithWeekHoliday() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MWorkTypeDto> listWorkType = dao.findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		aryWorkType = util.addArrayLastRowValue(aryWorkType,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		return aryWorkType;
	}

	/**
	 * Ζ`ԏ擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getWorkTypeDataArray() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MWorkTypeDto> listWorkType = dao.findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][8];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
			aryWorkType[i][2] = String.valueOf(listWorkType.get(i).getStartTime());
			aryWorkType[i][3] = String.valueOf(listWorkType.get(i).getQuitTime());
			aryWorkType[i][4] = String.valueOf(listWorkType.get(i).getWorkTime());
			aryWorkType[i][5] = String.valueOf(listWorkType.get(i).getBreakTime());
			aryWorkType[i][6] = String.valueOf(listWorkType.get(i).getOverStart());
			aryWorkType[i][7] = String.valueOf(listWorkType.get(i).getOverBreak());
		}
		return aryWorkType;
	}

	/**
	 * Ζ`ԃXg擾(CM_WORKTYPE)
	 * @return Ζ`ԃXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException 
	 */
	protected Map<String, MWorkTypeDto> getWorkTypeMap(
	) throws SQLException, NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MWorkTypeDto> listWorkType = dao.findAll();
		// Map̍쐬
		HashMap<String, MWorkTypeDto> map = new HashMap<String, MWorkTypeDto>();
		for (int i = 0; i < listWorkType.size(); i++) {
			map.put(listWorkType.get(i).getShiftCode(), listWorkType.get(i));
		}
		return map;
	}

	/**
	 * ER[h擾(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getPositionArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MYakusyokuDto> listPosition = dao.findAll();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode();
			aryPosition[i][1] = listPosition.get(i).getYName();
			aryPosition[i][2] = listPosition.get(i).getTokyu();
		}
		return aryPosition;
	}

	/**
	 * ER[h擾(L̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getPositionArray() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MYakusyokuDto> listPosition = dao.findAvailable();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode();
			aryPosition[i][1] = listPosition.get(i).getYName();
			aryPosition[i][2] = listPosition.get(i).getTokyu();
		}
		return aryPosition;
	}

	/**
	 * ER[h擾(̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getPositionTitleArray() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MYakusyokuDto> listPosition = dao.findForTitle();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode();
			aryPosition[i][1] = listPosition.get(i).getYName();
		}
		return aryPosition;
	}

	/**
	 * ER[h擾(v_Ep)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getPositionPltArray() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MYakusyokuDto> listPosition = dao.findAvailable();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][2];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode() + CommonConst.STR_TIME_SEPARATOR + listPosition.get(i).getTokyu();
			aryPosition[i][1] = listPosition.get(i).getYName();
		}
		return aryPosition;
	}

	/**
	 * EXg擾(M_YAKUSYOKU)
	 * @return EXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected Map<String, MYakusyokuDto> getPositionMap(
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MYakusyokuDto> listPosition = dao.findAll();
		// Map̍쐬
		HashMap<String, MYakusyokuDto> map = new HashMap<String, MYakusyokuDto>();
		for (int i = 0; i < listPosition.size(); i++) {
			map.put(listPosition.get(i).getYCode(), listPosition.get(i));
		}
		return map;
	}

	/**
	 * E擾(M_YAKUSYOKU)
	 * @param kcode		ΏێЈR[h
	 * @return dto		ΏێЈE
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected MYakusyokuDto getHoldingPositionInfo(
			String kCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		String positionCode = "";
		String grade = "0";
		// l{擾
		MKihonDto mKihonDto = getBasisInfo(kCode);
		if (mKihonDto != null) {
			// E擾
			positionCode = mKihonDto.getYCode();
			grade = mKihonDto.getTokyu();
		}
		MYakusyokuDto dto = dao.findForKey(positionCode, grade);
		return dto;
	}

	/**
	 * E̎擾(t)
	 * @param kCode		ΏێЈR[h
	 * @return	ΏێЈE
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getPositionName(
			String kCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		String name = "";
		MKihonDto dto = getBasisInfo(kCode);
		if (dto != null) {
			String position = dto.getYCode() + CommonConst.STR_TIME_SEPARATOR + dto.getTokyu();
			name = util.getCodeName(position, getPositionPltArray());
			if (name.equals(CommonConst.STR_TIME_SEPARATOR)) {
				name = "";
			}
		}
		return name;
	}

	/**
	 * ΑӒ擾
	 * @return	Date	Ώ۔N
	 * @throws Exception
	 */
	protected Date getCalcMonth() throws Exception{
		// DAO
		MKintaiKeisanDao dao = new MKintaiKeisanDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		MKintaiKeisanDto dto = dao.findForCalc();
		// Ώ۔Nl擾
		Date targetDate = util.getSystemDate();
		if (chkExistDto(dto)) {
			int closeDay = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
			if (closeDay == 0) {
				closeDay = 1;
			}
			targetDate = util.getDate(dto.getKTNen(), dto.getKTTuki(), closeDay);
		}
		return targetDate;
	}

	/**
	 * ΑӌvZ擾
	 * @return yyyymm vZN
	 * @throws Exception
	 */
	protected Date getCalcAttendance() throws Exception {
		// Ώ۔N擾
		Date targetDate = getCalcMonth();
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH)[2]);
		int closeDay   = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, minusMonth * -1);
		if (closeDay != 0) {
			cal.roll(Calendar.MONTH, 1);
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
		}
		return cal.getTime();
	}

	/**
	 * WvJn擾
	 * @param targetMonth Ώی
	 * @return WvJn
	 * @throws Exception
	 */
	protected Date getStartDate(Date targetMonth) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetMonth);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH)[2]);
		int closeDay   = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		cal.add(Calendar.MONTH, minusMonth * -1);
		// WvJnvZ
		if (closeDay != 0) {
			if (MospUtility.getDay(targetMonth) <= closeDay) {
				cal.add(Calendar.MONTH, -1);
			}
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return cal.getTime();
	}

	/**
	 * WvI擾
	 * @param targetMonth Ώی
	 * @return WvI
	 * @throws Exception
	 */
	protected Date getEndDate(Date targetMonth) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		// ߓ擾
		int closeDay   = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// Jn擾
		cal.setTime(getStartDate(targetMonth));
		// ꃖZ
		cal.add(Calendar.MONTH, 1);
		if (closeDay != 0) {
			// w
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		} else {
			// 
			cal.add(Calendar.MONTH, -1);
			// Ώی̍ŏIZbg
			cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
		}
		return cal.getTime();
	}

	/**
	 * Wv擾
	 * @param targetDate Ώۓ
	 * @return Wv
	 * @throws Exception
	 */
	protected Date getCurrentDate(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH)[2]);
		int closeDay   = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// Wv擾
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, minusMonth * -1);
		if (closeDay != 0) {
			if (MospUtility.getDay(targetDate) > closeDay) {
				cal.roll(Calendar.MONTH, 1);
			}
		}
		return cal.getTime();
	}

	/**
	 * ^xΏ۔N擾
	 * @param targetDate Ώۓ
	 * @return	iΑӏWvji^xj
	 * @throws Exception
	 */
	protected Date getCalcPayment(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// x擾
		int plusMonth	= Integer.parseInt(getMosPCode(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_MONTH)[2]);
		int providedDay	= Integer.parseInt(getMosPCode(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_DAYS)[2]);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, plusMonth * 1);
		// 1̏ꍇAxɂėN擾
		if ((cal.get(Calendar.MONTH) == 0)	&& plusMonth != 0) {
			cal.roll(Calendar.YEAR, 1);
		}
		if (providedDay != 0) {
			cal.set(Calendar.DAY_OF_MONTH, providedDay);
		}
		return cal.getTime();
	}

	/**
	 * ^x擾
	 * @return	Date	Ώ۔N
	 * @throws Exception
	 */
	protected Date getCalcPayment() throws Exception{
		// DAO
		MKintaiKeisanDao dao = new MKintaiKeisanDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		MKintaiKeisanDto dto = dao.findForCalc();
		// Ώ۔Nl擾
		Date targetDate = getCalcPayment(util.getSystemDate());
		if (chkExistDto(dto)) {
			targetDate = util.getDate(dto.getKSNen(), dto.getKSTuki(), dto.getKShi());
		}
		return targetDate;
	}

	/**
	 * \pJnN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N	
	 * @return \pJnN
	 * @throws Exception
	 */
	protected Date getStartDateForList(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		// ߓ擾
		int closeDay   = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// WvJnvZ
		if (closeDay != 0) {
			if (MospUtility.getDay(targetDate) <= closeDay) {
				cal.add(Calendar.MONTH, -1);
			}
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return cal.getTime();
	}

	/**
	 * \pIN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N
	 * @return \pJnN
	 * @throws Exception
	 */
	protected Date getEndDateForList(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		// ߓ擾
		int closeDay   = Integer.parseInt(getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// Jn擾
		cal.setTime(getStartDateForList(targetDate));
		// ꃖZ
		cal.add(Calendar.MONTH, 1);
		if (closeDay != 0) {
			// w
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		} else {
			// 
			cal.add(Calendar.MONTH, -1);
			// Ώی̍ŏIZbg
			cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
		}
		return cal.getTime();
	}

	/**
	 * L[l擾(L[)
	 * @param keyIndex L[CfbNX
	 * @return L[l
	 */
	protected String getKeyValue(int keyIndex) {
		String[] aryKey= key2.split(CommonConst.KEY_SEPARATOR);
		return aryKey[keyIndex];
	}

	/**
	 * ԍ擾()
	 * @param date1 It
	 * @param date2 Jnt
	 * @return ԍ(date1 - date2)
	 * @throws Exception
	 */
	protected long getTimeRemainder(Date date1, Date date2) {
		long timeRemainder = date1.getTime() - date2.getTime();
		return (timeRemainder / (1000 * 60));
	}

	/**
	 * r擾
	 * @param exclusiveType r敪
	 * @param userId        Ώۃ[U[ID
	 * @return ҏW҃R[h(ҏW҂ȂA܂͎̏ꍇnull)
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	protected String getExclusive(int exclusiveType, String userId) {
		listExclusive = (List)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		if (listExclusive == null) {
			return null;
		}
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = (ExclusiveVo)listExclusive.get(i);
			if (exclusiveVo.getExclusiveType() == exclusiveType) {
				if (exclusiveVo.getUserId().equals(userId)) {
					// ̔rf[^폜
					listExclusive.remove(i);
					continue;
				}
				return exclusiveVo.getUserId();
			}
		}
		return null;
	}

	/**
	 * rݒ
	 * @param exclusiveType r敪
	 * @param userId        Ώۃ[U[ID
	 * @param target        ҏWΏ
	 * @return ҏW҃R[h(ҏW҂ȂA܂͎̏ꍇnull)
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	protected String setExclusive(int exclusiveType, String userId, String target) {
		listExclusive = (List)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		String editor = null;
		if (listExclusive == null) {
			listExclusive = new ArrayList();
			ctx.setAttribute(CommonConst.ATT_EXCLUSIVE, listExclusive);
		}
		deleteExclusive(userId);
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = (ExclusiveVo)listExclusive.get(i);
			if (exclusiveVo.getExclusiveType() == exclusiveType && exclusiveVo.getTarget().equals(target)) {
				editor = exclusiveVo.getUserId();
			}
		}
		addList(listExclusive, new ExclusiveVo(exclusiveType, userId, target));
		return editor;
	}

	/**
	 * r폜
	 * @param userId Ώۃ[U[ID
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	protected void deleteExclusive(String userId) {
		listExclusive = (List)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		if (listExclusive == null) {
			return;
		}
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = (ExclusiveVo)listExclusive.get(i);
			if (getTimeRemainder(new Date(), exclusiveVo.getDate()) * 60 > Integer.parseInt(cfg.getProperty(MospConst.PPT_APP_INTERVAL))) {
				// ZbVێԈȏoĂrf[^폜
				listExclusive.remove(i);
			} else if (exclusiveVo.getUserId().equals(userId)) {
				// ̔rf[^폜
				listExclusive.remove(i);
			}
		}
	}

	/**
	 * t@C쐬
	 * @param upfile
	 * @return file
	 * @throws Exception
	 */
	protected File getUploadFile(FileItem upfile) throws Exception {
		// It@C擾
		File file = new File(upfile.getFieldName());
		// t@Cւ̏o
		upfile.write(file);
		return file;
	}

	/**
	 * t@C쐬(CSV)
	 * @param filCsv
	 * @return CSVt@Ce
	 * @throws Exception
	 */
	protected File getCSVFileData(FileItem filCsv) throws Exception {
		// It@C擾
		File csvData = new File(filCsv.getFieldName());
		// t@Cւ̏o
		filCsv.write(csvData);
		return csvData;
	}

	/**
	 * CSVf[^p[X
	 * @param filCsv
	 * @return CSVt@Ce
	 * @throws Exception
	 */
	protected CSVParser parseCSVData(File filCsv) throws Exception {
		br = new BufferedReader(new FileReader(filCsv));
		CSVParser csvParseData = new CSVParser(br);
		return csvParseData;
	}

	/**
	 * CSVwb_[쐬
	 * @param csvtarget
	 * @return wb_z
	 * @throws MospException
	 */
	protected String[] getCSVHeadData(CSVParser csvtarget) throws MospException {
		String[] line;
		try {
			line = csvtarget.getLine();
		} catch (IOException e) {
			// `G[
			String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_INVALID_HEAD_TYPE,"");
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		return line;
	}

	/**
	 * CSVf[^쐬
	 * @param csvtarget
	 * @param idx
	 * @return@f[^z
	 * @throws MospException
	 */
	protected String[] getCSVData(CSVParser csvtarget, int idx) throws MospException {
		String[] line;
		try {
			line = csvtarget.getLine();
		} catch (IOException e) {
			// `G[
			String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_INVALID_DATA_TYPE,String.valueOf(idx + 1));
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		return line;
	}

	/**
	 * f[^݊mF
	 * @param dto mFΏDTO
	 * @return boolean	ΏDTOݗL
	 * @throws MospException
	 */
	protected boolean chkExistDto(BaseDto dto) throws MospException {
		if (dto == null) {
			return false;
		}
		return true;
	}

	/**
	 * f[^݊mF
	 * @param obj mFΏObject
	 * @return boolean	ΏObjectݗL
	 * @throws MospException
	 */
	protected boolean chkExistObject(Object obj) throws MospException {
		if (obj == null) {
			return false;
		}
		return true;
	}

	/**
	 * jݒ
	 * @param dayOfWeek j
	 * @return j
	 */
	protected String getDayOfWeek(int dayOfWeek) {
		switch (dayOfWeek) {
		case Calendar.SUNDAY:
			return CommonConst.NAM_SUNDAY;
		case Calendar.MONDAY:
			return CommonConst.NAM_MONDAY;
		case Calendar.TUESDAY:
			return CommonConst.NAM_TUESDAY;
		case Calendar.WEDNESDAY:
			return CommonConst.NAM_WEDNESDAY;
		case Calendar.THURSDAY:
			return CommonConst.NAM_THURSDAY;
		case Calendar.FRIDAY:
			return CommonConst.NAM_FRIDAY;
		case Calendar.SATURDAY:
			return CommonConst.NAM_SATURDAY;
		default:
			return "";
		}
	}

	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	protected String getHourString(double hour) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumFractionDigits(2);
		nf.setMinimumFractionDigits(2);
		return nf.format(hour);
	}

	/**
	 * LJz
	 * @return	String[]	LJz
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[] getPaidHolidayInfo() throws SQLException, NoSuchFieldException, IllegalAccessException {
		String[] aryInfo = new String[3];
		// Jz
		aryInfo[0] = getMosPCode(CommonConst.NAM_PAID_HOLIDAY,
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_MONTH)[2];
		// Jz
		aryInfo[1] = getMosPCode(CommonConst.NAM_PAID_HOLIDAY,
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_NUMBER_OF_DAYS)[2];
		// Jz敪
		aryInfo[2] = getMosPCode(CommonConst.NAM_PAID_HOLIDAY, 
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_COMMON_TYPE)[2];
		return aryInfo;
	}

	/**
	 * LxɎx
	 * @return [0]cΑNA[1]cx
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected String[][] getPaidHolidayArray() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<MCodeDto> listCode = dao.findForHoliday(CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY);
		String[][] aryPaidHolidayDays = new String[listCode.size()][2];
		for (int i = 0; i < aryPaidHolidayDays.length; i++) {
			aryPaidHolidayDays[i][0] = listCode.get(i).getTCode();
			aryPaidHolidayDays[i][1] = listCode.get(i).getTChange();
		}
		return aryPaidHolidayDays;
	}

	/**
	 * o͔͈̓v_EXg
	 * @return	String[][]	o͔͈͔z
	 */
	protected String[][] getOutputScopeArray() {
		// ͈̓v_EXg쐬
		String[][] aryScope = new String[3][2];
		aryScope[0][0] = CommonConst.CODE_SCOPE_PERSONAL;
		aryScope[0][1] = CommonConst.NAM_SCOPE_PERSONAL;
		aryScope[1][0] = CommonConst.CODE_SCOPE_SECTION;
		aryScope[1][1] = CommonConst.NAM_SCOPE_SECTION;
		aryScope[2][0] = CommonConst.CODE_SCOPE_ALL;
		aryScope[2][1] = CommonConst.NAM_SCOPE_ALL;
		return aryScope;
	}

	/**
	 * ΑӏF@\󋵎擾(M_CODE)
	 * @return	boolean 	ΑӏF@\̗L
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected boolean isAttendanceApprovalFunction() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h̎擾
		MCodeDto dto = dao.findForKey(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL);     
		if (dto == null) {
			return false;
		} else {
			if (dto.getTName().equals(CommonConst.NAM_COMMON_FLAG_ON)) {
				return false;
			} else if (dto.getTName().equals(CommonConst.NAM_COMMON_FLAG_OFF)) {
				return true;
			} else {
				return false;
			}
		}
	}

	/**
	 * pX[hL
	 * @return	int		pX[hL
	 * @throws Exception
	 */
	protected int getPasswordTerm() throws Exception {
		int days = 0;
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h̎擾
		MCodeDto dto = dao.findForDto(CommonConst.TID_PASSWORD_TERM);
		if (dto != null) {
			days = Integer.parseInt(dto.getTChange());
		}
		return days;
	}

	/**
	 * tB[h̓̃f[^擾
	 *  0 : t@CID
	 *  1 : Ǘԍ
	 *  2 : tB[hID
	 *  3 : tB[h
	 */
	protected String getEFnameItem(String csvString, int i) {
		//@Ǘԍ擾
		if  (!csvString.equals(""))  {
			String[] arl;
			arl = csvString.split(CommonConst.STR_CSV_SEPARATOR);
			return arl[i];
		}
		return "";
	}

	/**
	 * YtOz
	 * @return YtOz
	 */
	protected String[][] getCorrespondFlagArray() {
		String[][] array = {
				{ CommonConst.NAM_COMMON_FLAG_OFF,	CommonConst.NAM_DEFAULT_FLAG_OFF	},
				{ CommonConst.NAM_COMMON_FLAG_ON,	CommonConst.NAM_DEFAULT_FLAG_ON		}				
		};
		return array.clone();
	}

	/**
	 * az
	 * @return	az
	 * @throws Exception
	 */
	protected String[][] getJPCalendarGengo() throws Exception {
		String[][] array = CommonConst.getJpCalendarGengo();
		String[][] aryGengo = getCodeArray(CommonConst.TID_JAPANESE);
		if (aryGengo.length > array.length) {
			array = aryGengo;
		}
		return array;
	}

	/**
	 * E蓖敪v_EXgiL{^Pj
	 * @return E蓖敪z
	 */
	protected String[][] getPositionAllowanceType1() {
		String[][] array = {
				{ CommonConst.CODE_ALLOWANCE_NONE, 		CommonConst.NAME_ALLOWANCE_NONE		},
				{ CommonConst.CODE_ALLOWANCE_STATE_1, 	CommonConst.NAME_ALLOWANCE_SALARY	}
		};
		return array.clone();
	}

	/**
	 * E蓖敪v_EXgiL{ŒPj
	 * @return E蓖敪z
	 */
	protected String[][] getPositionAllowanceType2() {
		String[][] array = {
				{ CommonConst.CODE_ALLOWANCE_NONE, 		CommonConst.NAME_ALLOWANCE_NONE		},
				{ CommonConst.CODE_ALLOWANCE_STATE_1, 	CommonConst.NAME_ALLOWANCE_FIXED	}
		};
		return array.clone();
	}

	/**
	 * E蓖敪v_EXgiL{^P{ŒPj
	 * @return E蓖敪z
	 */
	protected String[][] getPositionAllowanceType3() {
		String[][] array = {
				{ CommonConst.CODE_ALLOWANCE_NONE, 		CommonConst.NAME_ALLOWANCE_NONE		},
				{ CommonConst.CODE_ALLOWANCE_STATE_1, 	CommonConst.NAME_ALLOWANCE_SALARY	},
				{ CommonConst.CODE_ALLOWANCE_STATE_2, 	CommonConst.NAME_ALLOWANCE_FIXED	}
		};
		return array.clone();
	}

	/**
	 * DTOꐫ`FbN
	 * @param formerDto		ΏDTO
	 * @param currentDto	ΏDTO
	 * @return
	 * <p>
	 * XV̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws MospException 
	 */
	protected boolean chkIdentityDto(BaseDto formerDto, BaseDto currentDto) throws MospException {
		boolean isSame = false;
		chkExist(currentDto);
		if (formerDto.getUpdateDate().compareTo(currentDto.getUpdateDate()) == 0) {
			isSame = true;
		}
		return isSame;
	}

	/**
	 * Ώ۔NΏ۔Nx擾
	 * @param year		Ώ۔N
	 * @param month		Ώی
	 * @param startmonth	NxJn
	 * @return	Ώ۔Nx
	 * @throws Exception
	 */
	protected int getTargetFiscalYear(int year, int month, int startmonth) throws Exception {
		// NxJnȌꍇΏ۔N̑ONgpB
		// NxJň̏ꍇ͑Ώ۔Ngp
		int fiscalyear = year;
		if (month < startmonth) {
			fiscalyear--;
		}
		return fiscalyear;
	}

	/**
	 * Ώ۔NxΏ۔N擾
	 * @param fiscalyear		Ώ۔Nx
	 * @param month				Ώی
	 * @param startmonth		NxJn
	 * @return	Ώ۔N
	 */
	protected int getTargetYear(int fiscalyear, int month, int startmonth) {
		// NxJn̑O͑Ώ۔Nx̗N𗘗p
		// NxJň̌͑Ώ۔Nxgp
		int year = fiscalyear;
		if (month < startmonth) {
			year++;
		}
		return year;
	}

	/**
	 * Ώ۔NxJn擾
	 * @param year		Ώ۔Nx
	 * @return Ώ۔NxJn
	 */
	protected Date getFiscalStartDate(int fiscalyear, int startMonth) throws Exception {
		return util.getFirstDateOfMonth(getTargetFiscalYear(fiscalyear, startMonth, startMonth), startMonth);
	}

	/**
	 * Ώ۔NxI擾
	 * @param year		Ώ۔Nx
	 * @return Ώ۔NxI
	 */
	protected Date getFiscalEndDate(int fiscalyear, int startMonth) throws Exception {
		return util.getLastDateOfMonth(fiscalyear + 1, startMonth -1);
	}

	/**
	 * a\ݒ
	 * @param vo			MosPVopΏVO
	 * @param targetDate	Ώ۔N
	 * @return	a\
	 * @throws MospException
	 * @throws Exception
	 */
	protected String getJapaneseDate(MosPVo vo, Date targetDate) throws MospException, Exception {
		return vo.getJapaneseDate(
				getConfList(CommonConst.CONF_ID_JP_IMP_CAL),
				getJPCalendarGengo(),
				targetDate
		);
	}

	/**
	 * a\ݒ
	 * @param vo			MosPVopΏVO
	 * @param targetDate	Ώ۔N(yyyy-mm-dd)
	 * @return	a\
	 * @throws MospException
	 * @throws Exception
	 */
	protected String getJapaneseDate(MosPVo vo, String targetDate) throws MospException, Exception {
		return vo.getJapaneseDate(
				getConfList(CommonConst.CONF_ID_JP_IMP_CAL),
				getJPCalendarGengo(),
				util.convHyphenDateToDate(targetDate)
		);
	}

	/**
	 * 񍀖ڗpz擾
	 * @param tableName		Ώۃe[u
	 * @return	 񍀖ڗpz
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	protected String[] getTableColumnInfo(
			String tableName
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		MExportColumnDao dao = new MExportColumnDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<MExportColumnDto> list = dao.findForCondition(tableName);
		String[] aryColumnInfo = new String[list.size()];
		int i = 0;
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			MExportColumnDto dto = (MExportColumnDto) iter.next();
			StringBuffer sb = new StringBuffer();
			sb.append(tableName.toUpperCase(Locale.JAPANESE));
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(i + 1);
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(dto.getColumnField().toUpperCase(Locale.JAPANESE));
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(dto.getColumnComment());
			aryColumnInfo[i] = sb.toString();
			i++;
		}
		return aryColumnInfo;
	}

	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID	Ώۃe[uR[h
	 * @return	String[][]	GNX|[g񍀖ڔz
	 * @throws Exception
	 */
	protected String[][] getKintaiDataItem(String strFLID) throws Exception {
		ExportInfoUtility exportUtility = new ExportInfoUtility(
				getTableColumnInfo(jp.mosp.human.dao.MKihonDao.TABLE),
				getTableColumnInfo(jp.mosp.payroll.dao.MKintaiDao.TABLE),
				getTableColumnInfo(jp.mosp.kintai.dao.MSyukkinboDao.TABLE),
				getTableColumnInfo(jp.mosp.kintai.dao.MYukyuDao.TABLE)
		);
		return exportUtility.getKintaiDataItem(strFLID);
	}

	/**
	 * FXe[^XR[hXg擾
	 * @return FXe[^XR[hXgz
	 */
	protected String[] getApprovalStatusCodeArray() {
		// z̍쐬
		String[] aryStatus = new String[5];
		aryStatus[0] = CommonConst.NUM_ATTENDANCE_REQUEST;
		aryStatus[1] = CommonConst.NUM_ATTENDANCE_1ST_APPROVED;
		aryStatus[2] = CommonConst.NUM_ATTENDANCE_1ST_RETURNED;
		aryStatus[3] = CommonConst.NUM_ATTENDANCE_2ND_APPROVED;
		aryStatus[4] = CommonConst.NUM_ATTENDANCE_2ND_RETURNED;
		return aryStatus;
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getConnection()
	 */
	protected void getConnection() throws ClassNotFoundException, SQLException {
		boolean isDefault = true;
		// DataSourcepł邩f
		if (canUseDataSource()) {
			try {
				getConnection(cfg.getProperty(MospConst.PPT_ASP_DSOURCE));
			} catch (Exception e) {
				// G[Oɏo͂B
				LogUtility.log(cfg, "", "", cmd, 5, MospConst.LOG_MOSPERR, MospConst.LOG_MSG_5003);
			} finally {
				if (conn != null) {
					isDefault = false;
				} else {
					// ݒ肪G[̏ꍇAftHg̐ڑ𗘗pB
					cfg.setProperty(CommonConst.PPT_USE_DATA_SOURCE, String.valueOf(false));
				}
			}
		}
		if (isDefault) {
			super.getConnection();
		}
	}

	/**
	 * DataSourcep۔f
	 * @return
	 * <p>
	 * DataSourcepłꍇtrueAłȂꍇfalse<br>
	 * xfAcfgɃZbg񂩂炻𗘗pB
	 * </p>
	 */
	protected boolean canUseDataSource() {
		// ݒt@C̃vpeB擾
		String pptDataSource = cfg.getProperty(CommonConst.PPT_USE_DATA_SOURCE);
		if (pptDataSource == null) {
			// vpeBɖꍇAݒ肷B
			boolean dsourceFlag = false;
			if (DataSourceUtility.canUseDataSource(cfg.getProperty(MospConst.PPT_ASP_DSOURCE))) {
				dsourceFlag = true;
				LogUtility.log(cfg, "", "", "", 4, MospConst.LOG_MOSPINF, DataSourceUtility.USE_DATA_SOURCE_MESSAGE);
			}
			cfg.setProperty(CommonConst.PPT_USE_DATA_SOURCE, String.valueOf(dsourceFlag));
			pptDataSource = String.valueOf(dsourceFlag);
		}
		return Boolean.valueOf(pptDataSource);
	}

	/**
	 * R}h擾B<br>
	 * @param invalidProcSeq V[PXstO
	 * @return R}h
	 */
	@Override
	protected String getIndexCommand(boolean invalidProcSeq) {
		try {
			// ASP[U[擾(ݒt@CASPݒŔf)
			switch (MospUtility.getAspFlag(cfg)) {
			case 0:
			case 1:
				// 0FASP(x[U[:1Av)
				// 1FASP(1[U[:1Av)
				return "C3011";
			case 2:
				// 2FASP
				return MospConst.CMD_INDEX;
			default:
				return MospConst.CMD_INDEX;
			}
		} catch (MospException e) {
			return MospConst.CMD_INDEX;
		}
	}

	/*
	 * ȉAIvV֘Ã\bh
	 */	

	/**
	 * OptionConst擾
	 * @return	OptionConst̃NXIuWFNg
	 * @throws ClassNotFoundException
	 */
	protected Class getOptionConstClass() throws ClassNotFoundException {
		return Class.forName(CommonConst.OPTION_CONST_FULLNAME);
	}

	/**
	 * IvV@\L
	 * <p>2008/12/10	m.yoshida	ǉ</p>
	 * @return useOption
	 * <p>
	 * IvV@\𗘗p邱ƂłꍇtrueA<br>
	 * łȂꍇfalse
	 * </p>
	 */
	protected boolean canUseOptionPackage() {
		// ݒt@C̃vpeB擾
		try {
			if (cfg.getProperty(CommonConst.PPT_USE_OPTION) == null) {
				// OptionConstNX݂邩mF
				Class cls = getOptionConstClass();
				// vpeBɖꍇAݒ肷B
				if (cls != null) {
					cfg.setProperty(CommonConst.PPT_USE_OPTION, String.valueOf(true));
				}
			}
		} catch (ClassNotFoundException e) {
			cfg.setProperty(CommonConst.PPT_USE_OPTION, String.valueOf(false));
		}
		return Boolean.valueOf(cfg.getProperty(CommonConst.PPT_USE_OPTION));
	}

	/**
	 * {R[hz擾
	 * @return	{R[hz
	 * <p>
	 * [0]c
	 * [1]cI𕔏
	 * [2]cS
	 * </p>
	 */
	protected int[] getManageCode() {
		int[] aryCode = new int[3];
		aryCode[0] = Integer.parseInt(CommonConst.NUM_BELONGING_SECTION);
		aryCode[1] = Integer.parseInt(CommonConst.NUM_SELECT_SECTION);
		aryCode[2] = Integer.parseInt(CommonConst.NUM_ALL_SECTION);
		return aryCode;
	}

	/**
	 * {v_EXg
	 * @return	String[][]	o͔͈͔z
	 */
	protected String[][] getManageArray() {
		// ͈̓v_EXg쐬
		String[][] aryScope = new String[3][2];
		aryScope[0][0] = String.valueOf(getManageCode()[0]);
		aryScope[0][1] = CommonConst.NAM_BELONGING_SECTION;
		aryScope[1][0] = String.valueOf(getManageCode()[1]);
		aryScope[1][1] = CommonConst.NAM_SELECT_SECTION;
		aryScope[2][0] = String.valueOf(getManageCode()[2]);
		aryScope[2][1] = CommonConst.NAM_ALL_SECTION;
		return aryScope;
	}

	// ANZT\bh
	protected void setNeedExclusive(boolean needExclusive) { this.needExclusive = needExclusive; }

}
